%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Novel SFDC"
% Jianglin Lan, Feb 10th, 2015, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = Simultaneous_closed_sys_performance(t,xx,A,B,F,D1,C,D2,Kx,Kf,H,G,M,L)
Z = xx(1:4);
X = xx(5:6);

global Int_ffa Int_ffs Int_u Int_yy2 Int_ts Int_count Int_tmp Int_hatd  Int_hatfa

d = 2*sin(2*pi*t); % disturbance
fa = f(t); % fault
xd = 1; % output tracking reference

%controller
X = X - [xd; 0];
y = C*X + D2*d + [1;1]*noise(t);
hat_x = Z + H*y;
K = [Kx Kf];
u = K * hat_x(1:3);

%observer
bar_B = [B;zeros(2,1)];
GB = G*bar_B;
dot_Z = M*Z + GB*u + L*y;


% sys dynamic
dot_X = A*X + B*u + F*fa + D1*d;
y0 = y - D2*hat_x(4);

% data saving 
if mod(Int_tmp,12)==0
    Int_count = Int_count + 1;
Int_ts(Int_count) = t;
Int_ffa(Int_count) = fa;
Int_ffs(Int_count) = d;
Int_u(Int_count) = u;
Int_yy2(Int_count) = y0(2);
Int_hatfa(Int_count) = fa - hat_x(3);
Int_hatd(Int_count) = d - hat_x(4);
end
Int_tmp = Int_tmp + 1;

sys_state = [dot_Z;dot_X];